############################################################
######################  Data Analysis  #####################
#########       Correct sfo value in F1 dim        #########
############################################################


### jeco
### jerome.coutant@bruker.fr
### 21-02-2019
### Bruker Biospin Wissembourg
### Use this script to correct F1 scale if offset is wrong


import os
import shutil

######################################################################
#define datatree

global curdat
global data


curdat = CURDATA()
name = curdat[0]
expno = curdat[1]
procno = curdat[2]
user = curdat[3]


if len(CURDATA())==5:
	curdir = curdat[3]+'/data/'+curdat[4]+'/nmr/'+curdat[0]+'/'+curdat[1]+"/"
else :
	curdir = curdat[3]+"/"+curdat[0]+"/"+curdat[1]+"/"

#########################################################################
#Get sfo2 value from acquisition parameter
#########################################################################

sfo = str(GETPAR("SFO1"))
#MSG("sf : "+str(sfo))

#########################################################################
#open acqus file
#search SFO1 line
#replace old SFO1 value with real SFO2 value
#########################################################################

facqu2s = open(curdir+"acqu2s", "r")
txt = []

search = "##$SFO1= "

while 1 :
	line = facqu2s.readline()
	if line == "" :
		break
	else :
		splitline = line.split(""+search)
		if len(splitline) != 2 :
			#MSG("line"+str(line))
			txt.append(line)
		#MSG("ligne : "+str(len(line)))
		else :
			txt.append(search+" "+sfo+"\n")

facqu2s.close()

#########################################################################
#modify acqu2s file
#########################################################################

facqu2s = open(curdir+"acqu2s", "w")

for i in range(len(txt)) :
	facqu2s.write(str(txt[i]))

facqu2s.close()



